<?php

namespace App\Http\Controllers\SuperAdmin;

use App\Http\Controllers\Controller;
use App\Models\BookAppointment;
use App\Models\TherapistCommunity;
use App\Models\Therapist;
use App\Models\User;
use App\Models\Customer;
use App\Models\Event;

use Illuminate\Http\Request;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class DashboardController extends Controller
{
    public function home(Request $request)
    {
        $totalTherapists = Therapist::count();
        $totalTherapistCommunitys = TherapistCommunity::count();
        $totalBookedAppointments = BookAppointment::count();
        $totalUsers = Customer::count();
        $totalBlogCategories = 15;
        $totalSubscriptions = DB::table('subscriptions')->count();
        $totalEvents = Event::count();
        $totalLowProfileTherapists = 0;
        $allTherapist = Therapist::has('therapist_reviews')->get();

        foreach ($allTherapist as $key => $therapist) {
            $rating = $therapist->therapist_reviews()->avg('rating');
            if (!empty($rating) && $rating < 2) {
                $totalLowProfileTherapists++;
            }
        }
        $totalCompleteTherapistProfiles = User::whereHas('therapist', function ($q) {
            $q->where('profile_completion_percentage', '>=', 25);
        })->count();
        $totalCompleteTherapistCommunityProfiles = User::whereHas('therapist_community', function ($q) {
            $q->where('profile_completion_percentage', '>=', 25);
        })->count();
        $allTherapistCommunitys = TherapistCommunity::has('therapist_community_reviews')->get();
        $totalLowProfileTherapistCommunitys = 0;
        foreach ($allTherapistCommunitys as $key => $therapist_community) {
            $rating = $therapist_community->therapist_community_reviews()->avg('rating');
            if (!empty($rating) && $rating < 2) {
                $totalLowProfileTherapistCommunitys++;
            }
        }
        $recordsByMonthThisYear = DB::table('booked_appointments')
            ->selectRaw('YEAR(created_at) as year, MONTH(created_at) as month, COUNT(*) as count')
            ->where('created_at', '>=', Carbon::now()->subMonths(6)->startOfMonth())
            ->where('created_at', '<=', Carbon::now()->endOfMonth())
            ->groupBy('year', 'month')
            ->orderBy('year', 'asc')
            ->orderBy('month', 'asc')
            ->get();
        $appointmentRecordsByMonthsKeyed = [
            'Total' => 0
        ];

        foreach ($recordsByMonthThisYear as $group) {
            $year = $group->year;
            $month = $group->month;
            $count = $group->count;

            $monthKey = Carbon::createFromDate($year, $month, 1)->format('F');

            $appointmentRecordsByMonthsKeyed[$monthKey] = $count;
            $appointmentRecordsByMonthsKeyed['Total'] = $count + $appointmentRecordsByMonthsKeyed['Total'];
        }
        $recordsByMonthLastYear = DB::table('booked_appointments')
            ->selectRaw('YEAR(created_at) as year, MONTH(created_at) as month, COUNT(*) as count')
            ->where('created_at', '>=', Carbon::now()->subMonths(18)->startOfMonth())
            ->where('created_at', '<=', Carbon::now()->subMonths(12))
            ->groupBy('year', 'month')
            ->orderBy('year', 'asc')
            ->orderBy('month', 'asc')
            ->get();
        $appointmentRecordsByLasteYearMonthsKeyed = ['Total' => 0];

        foreach ($recordsByMonthLastYear as $group) {
            $year = $group->year;
            $month = $group->month;
            $count = $group->count;

            $monthKey = Carbon::createFromDate($year, $month, 1)->format('F');

            $appointmentRecordsByLasteYearMonthsKeyed[$monthKey] = $count;
            $appointmentRecordsByLasteYearMonthsKeyed['Total'] = $count + $appointmentRecordsByMonthsKeyed['Total'];
        }
        $currentWeekStart = Carbon::now()->startOfWeek();
        $currentWeekEnd = Carbon::now()->endOfWeek();
        $lastWeekStart = Carbon::now()->subWeek()->startOfWeek()->format('Y-m-d');
        $lastWeekEnd = Carbon::now()->subWeek()->endOfWeek()->format('Y-m-d');

        $currentWeekCustomers = DB::table('customers')
            ->selectRaw('DAYOFWEEK(created_at) as day, COUNT(*) as count')
            ->whereBetween('created_at', [$currentWeekStart, $currentWeekEnd])
            ->groupBy('day')
            ->orderBy('day')
            ->get();
        $tempCurrentWeekCustomers = [];
        foreach ($currentWeekCustomers as $group) {
            $day = $group->day . 'th';
            $count = $group->count;
            $tempCurrentWeekCustomers[$day] = $count;
        }
        $lastWeekCustomers = DB::table('customers')
            ->selectRaw('DAYOFWEEK(created_at) as day, COUNT(*) as count')
            ->whereBetween('created_at', [$lastWeekStart, $lastWeekEnd])
            ->groupBy('day')
            ->orderBy('day')
            ->get();
        $templastWeekCustomers = [];
        foreach ($lastWeekCustomers as $group) {
            $day = $group->day . 'th';
            $count = $group->count;
            $templastWeekCustomers[$day] = $count;
        }

        $data = [
            'totalUsers' => $totalUsers,
            'totalBookedAppointments' => $totalBookedAppointments,
            'totalBlogCategories' => $totalBlogCategories,
            'totalSubscriptions' => $totalSubscriptions,
            'totalTherapists' => $totalTherapists,
            'total_therapist_communitys' => $totalTherapistCommunitys,
            'total_subscriptions' => $totalUsers,
            'totalLowProfileTherapists' => $totalLowProfileTherapists,
            'totalCompleteTherapistProfiles' => $totalCompleteTherapistProfiles,
            'totalCompleteTherapistCommunityProfiles' => $totalCompleteTherapistCommunityProfiles,
            'totalLowProfileUsers' => $totalLowProfileTherapists + $totalLowProfileTherapistCommunitys + $totalLowProfileTherapistCommunitys + $totalCompleteTherapistCommunityProfiles,
            'totalLowProfileTherapistCommunitys' => $totalLowProfileTherapistCommunitys,
            'appointmentRecordsByMonthsKeyed' => $appointmentRecordsByMonthsKeyed,
            'appointmentRecordsByLasteYearMonthsKeyed' => $appointmentRecordsByLasteYearMonthsKeyed,
            'currentWeekCustomers' => $tempCurrentWeekCustomers,
            'lastWeekCustomers' => $templastWeekCustomers,
            'totalEvents' => $totalEvents,
        ];

        return view('super_admins.dashboard', compact('data'));
    }

    public function viewNotification(Request $request, $type)
    {
        if ($type == 'low_profile_therapists') {
            /********* Get Low Profile Therapists  **********/
            $allTherapists = Therapist::has('therapist_reviews')->get();
            $therapist_ids = [];
            foreach ($allTherapists as $key => $therapist) {
                $rating = $therapist->therapist_reviews()->avg('rating');
                if (!empty($rating) && $rating < 2) {
                    $therapist_ids[] = $therapist->id;
                }
            }
            $therapists = Therapist::whereIn('id', $therapist_ids)->get();
            return view('super_admins.view_notifications_therapists.index')->with('therapists', $therapists);
        } else if ($type == 'low_profile_therapist_communitys') {
            /********* Get Low Profile TherapistCommunitys  **********/
            $allTherapistCommunitys = TherapistCommunity::has('therapist_community_reviews')->get();
            $therapist_community_ids = [];
            foreach ($allTherapistCommunitys as $key => $therapist_community) {
                $rating = $therapist_community->therapist_community_reviews()->avg('rating');
                if (!empty($rating) && $rating < 2) {
                    $therapist_community_ids[] = $therapist_community->id;
                }
            }
            $therapist_communitys = TherapistCommunity::whereIn('id', $therapist_community_ids)->get();
            return view('super_admins.view_notifications_therapist_communitys.index')->with('therapist_communitys', $therapist_communitys);
        } else if ($type == 'completed_therapist_profiles') {
            /********* Get completed_therapist_profiles  **********/
            $therapists = Therapist::where('profile_completion_percentage', '>=', 25)->get();
            return view('super_admins.view_notifications_therapists.index')->with('therapists', $therapists);
        } else if ($type == 'completed_therapist_community_profiles') {
            /********* Get completed_therapist_community_profiles  **********/
            $therapist_communitys = TherapistCommunity::where('profile_completion_percentage', '>=', 25)->get();
            return view('super_admins.view_notifications_therapist_communitys.index')->with('therapist_communitys', $therapist_communitys);
        }
    }
    public function notAllowed(Request $request)
    {
        return view('super_admins.not_allowed');
    }
}
